/* $Id: syscalls.h,v 1.7 1998/07/20 21:05:54 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

#ifndef	_E1432_SYSCALLS_H
#define	_E1432_SYSCALLS_H

/* System calls from 96002 to Godzilla downloadable or host */
#define	SYSCALL__EXIT		1
#define	SYSCALL_CLOSE		2
#define	SYSCALL_FSTAT		3
#define	SYSCALL_GETTIMEOFDAY	4
#define	SYSCALL_ISATTY		5
#define	SYSCALL_LINK		6
#define	SYSCALL_LSEEK		7
#define	SYSCALL_OPEN		8
#define	SYSCALL_READ		9
#define	SYSCALL_STAT		10
#define	SYSCALL_TIMES		11
#define	SYSCALL_UNLINK		12
#define	SYSCALL_WRITE		13

#ifndef	__DSP96K__

#include "machType.h"

/* Warning, these must match gcc 96k definitions */
#define	GCC96_CHAR		4	/* char is 32 bits! */
#define	S_IFCHR96		020000
#define	S_IRWXU96		000700
#define	S_IRWXG96		000070
#define	S_IRWXO96		000007
struct stat96
{
    LONGSIZ32	st_dev;
    LONGSIZ32	st_ino;
    LONGSIZ32	st_mode;
    LONGSIZ32	st_nlink;
    LONGSIZ32	st_uid;
    LONGSIZ32	st_gid;
    LONGSIZ32	st_rdev;
    LONGSIZ32	st_size;
    LONGSIZ32	st_atime;
    LONGSIZ32	st_spare1;
    LONGSIZ32	st_mtime;
    LONGSIZ32	st_spare2;
    LONGSIZ32	st_ctime;
    LONGSIZ32	st_spare3;
    LONGSIZ32	st_blksize;
    LONGSIZ32	st_blocks;
    LONGSIZ32	st_spare4[2];
};

struct timeval96
{
    LONGSIZ32 tv_sec;
    LONGSIZ32 tv_usec;
};

struct timezone96
{
    LONGSIZ32 tz_minuteswest;
    LONGSIZ32 tz_dsttime;
};

struct tms96
{
    unsigned LONGSIZ32 tms_utime;	/* user time */
    unsigned LONGSIZ32 tms_stime;	/* system time */
    unsigned LONGSIZ32 tms_cutime;	/* user time, children */
    unsigned LONGSIZ32 tms_cstime;	/* system time, children */
};

#define	O_ACCMODE96	3
#define	O_NDELAY96	0x0004	/* non blocking I/O (4.2 style) */
#define	O_APPEND96	0x0008	/* append (writes guaranteed at the end) */
#define	O_CREAT96	0x0200	/* open with file create */
#define	O_TRUNC96	0x0400	/* open with truncation */
#define	O_EXCL96	0x0800	/* error on open if file exists */
#define	O_NBIO96	0x1000	/* non blocking I/O (sys5 style) */
#define	O_SYNC96	0x2000	/* do all writes synchronously */
#define	O_NONBLOCK96	0x4000	/* non blocking I/O (POSIX style) */
#define	O_NOCTTY96	0x8000	/* don't assign a ctty on this open */

/* Structure passed from Godzilla downloadable to host */
struct hostsys
{
    LONGSIZ32     type;
    LONGSIZ32     parm1;
    LONGSIZ32     parm2;
    LONGSIZ32     parm3;
    LONGSIZ32     nbyte;
};

#endif	/* !__DSP96K__ */
#endif	/* _E1432_SYSCALLS_H */
